(function(){

    exports.callback0 = function () {
        // Load native UI library
        var gui = global.window.nwDispatcher.requireNwGui() ;
        // Get the current window
        var win = gui.Window.get();
        // Do the things if you want to do it once after app startup.
        if (gui.App.manifest.isFirstTimeStartup) {
            gui.App.manifest.isFirstTimeStartup = false;
            // avoid error-page on node-webkit if any errors.
            process.on("uncaughtException", function(e) { console.error(e); });
            // Set menu bar for Mac system, this will make copy/paste work.
            if (process.platform === "darwin") {
                var nativeMenuBar = new gui.Menu({ type: "menubar" });
                nativeMenuBar.createMacBuiltin("Cmd Markdown");
                win.menu = nativeMenuBar;
            }
            // Show and maximize window
            win.show();
            win.maximize();
            win.on('new-win-policy', function (frame, url, policy) { // put this into isFirstTimeStartup if block, otherwise, every new page will lead to one more time to open the external url.
                gui.Shell.openExternal(url);
                policy.ignore();
            });
        }
        return gui.App;
    };

})();
